/* ============ */
/* < qhead.h >	*/
/* ============ */
/* ==================================================================== */
/*	INCLUDE FILE FOR EXTENDED PRECISION ARITHMETIC PROGRAMS		*/
/* ==================================================================== */

# if defined(__QHEAD_H__)
#	/* Do Nothing */
# else
#	define	__QHEAD_H__

/* Number of 16 bit words in a q type number */
# if defined(U144)
#	define	NQ 12
# else
#	define NQ 24
# endif

#define	NE	NQ

/* Number of words in significand area */
#define OMG (NQ-2)

/* Byte offset to least significant word of significand */
#define OFFS (2*OMG+2)

/* Number of bits of precision */
#define NBITS ((OMG-1)*16)

/* Maximum number of decimal digits in conversion */
#define NDEC (NBITS*8/27)

#define	EHALF  	QHALF
#define	ELOG2  	QLOG2
#define	EONE   	QONE
#define	EPI    	QPI
#define	ESQRT2 	QSQRT2
#define	ETWO   	QTWO
#define	EZERO  	QZERO


#define	QZERO	qzero
#define	QHALF   qhalf
#define	QONE    qone
#define	QTWO    qtwo
#define	Q32     q32
#define	QLOG2   qlog2
#define	QSQRT2  qsqrt2
#define	ONEOPI  oneopi
#define	QPI     qpi
#define	QEUL    qeul

extern unsigned short qzero[];
extern unsigned short qhalf[];
extern unsigned short qone[];
extern unsigned short qtwo[];
extern unsigned short q32[];
extern unsigned short qlog2[];
extern unsigned short qsqrt2[];
extern unsigned short oneopi[];
extern unsigned short qpi[];
extern unsigned short qeul[];
# endif			/* < qhead.h >	*/
